#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//   Swetugg presentation shaderMod01.fsh   by    mrange  
//https://www.shadertoy.com/view/mdyBRG
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// CC0: Swetugg presentation shader

// Hello this the result of the Swetugg live coding session called
//  'Literally beautiful code' 2023-10-26 in Gothenburg, Sweden.

// Thanks to the organizers for a great event and thanks to all that
//  watched me hack some shader code live.

// Here are some useful links to help you get started.

// ShaderToy - A great place to code and learn together with a great
//  community - You are here!

// IQ Articles - A great resource by the great IQ, I visit this very often
//  - https://iquilezles.org/articles

// The Art of Code - A great YT channel by the great BigWings that 
//  helps you get started with very basics of shader programming
//  - https://www.youtube.com/@TheArtofCodeIsCool

// An Introduction Shader Art Coding - By the great kishimisu
//  - https://www.youtube.com/@kishimisu

// Windows Terminal Shader Gallery - You know you want shaders 
//  in windows terminal by me
//   - https://github.com/mrange/windows-terminal-shader-gallery
#define ROT(a)      mat2(cos(a), sin(a), -sin(a), cos(a))

float circle(vec2 p, float r) {
  return length(p) - r ;
}

vec3 palette(float a) {
  return 0.5+0.5*sin(vec3(0,1,2) + a);
}

// License: MIT, author: Inigo Quilez, found: https://iquilezles.org/www/articles/distfunctions2d/distfunctions2d.htm
float star5(in vec2 p, in float r, in float rf) {
    const vec2 k1 = vec2(0.809016994375, -0.587785252292);
    const vec2 k2 = vec2(-k1.x,k1.y);
    p.x = abs(p.x);
    p -= 2.0*max(dot(k1,p),0.0)*k1;
    p -= 2.0*max(dot(k2,p),0.0)*k2;
    p.x = abs(p.x);
    p.y -= r;
    vec2 ba = rf*vec2(-k1.y,k1.x) - vec2(0,1);
    float h = clamp( dot(p,ba)/dot(ba,ba), 0.0, r );
    return length(p-ba*h) * sign(p.y*ba.x-p.x*ba.y);
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
  vec2 q = fragCoord/iResolution.xy;
  vec2 p = -1. + 2. * q;
  p.x *= iResolution.x/iResolution.y;
  vec3 col = vec3(0.0, 0. ,0.0);
  
  for (int i=0; i<5;++i) { 
    vec2 p0 = p;
    float itime = iTime+1.2*float(i);
    p0.x += sin(itime);
    float b = itime;
    b = fract(b);
    b -= 0.5;
    b *= b;
    b *= 2.0;
    p0.y += b;
  
    p0 *= ROT(8.0*cos(itime));  
    float d = star5(p0, 0.5, 0.5);
    float od = abs(d)-0.015;
    
    if (d < 0.0) {
      col = palette(itime-8.0*d);
    }
    
    if (od < 0.0) {
      col = vec3(q.y);
    }
  }
  //col.x += sin(40.0*d);
  col = sqrt(col);
  
  fragColor = vec4(col, 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

